<?php

/*
 * Register Advanced Custom Fields if needed
 */
add_action('after_setup_theme', 'maddos_register_acf_fields');

/*
 * Register Advanced Custom Fields (ACF)
 */
if ( ! function_exists( 'maddos_register_acf_fields' ) ) :
function maddos_register_acf_fields() {
if(function_exists("register_field_group"))
{
	register_field_group(array (
		'id' => 'acf_maddos-categories',
		'title' => 'Maddos Categories',
		'fields' => array (
			array (
				'key' => 'field_5612c016101e0',
				'label' => 'Category Icon',
				'name' => 'cat_icon',
				'type' => 'text',
				'instructions' => 'A url or html code. Max size will be 24x24.',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5617ce37944e5',
				'label' => 'Category Height',
				'name' => 'cat_height',
				'type' => 'text',
				'instructions' => 'Sets a maximum height for this category listing on the directory page. Overrides the default height set in Directory Options.',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'ef_taxonomy',
					'operator' => '==',
					'value' => 'category',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'no_box',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_maddos-posts',
		'title' => 'Maddos Post Info',
		'fields' => array (
			array (
				'key' => 'field_560c0e2cc0edc',
				'label' => 'Site Url',
				'name' => 'site_url',
				'type' => 'text',
				'instructions' => 'The url this post title will link to on the directory page. Can be a redirect or cloaked link. If left empty will link to the post instead.',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
		array(
			'key' => 'field_5e3b3fd091d4d',
			'label' => 'Options',
			'name' => 'options',
			'type' => 'checkbox',
			'instructions' => 'This overrides all other group settings, such as the Maddos Widget or Post Options.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'new_tab' => 'Open all Site Url links in new tab',
				'no_follow' => 'No Follow all Site Url links',
				'exclude_post' => 'Exclude this post from all Directory Pages',
			),
			'allow_custom' => 0,
			'default_value' => array(
			),
			'layout' => 'horizontal',
			'toggle' => 0,
			'return_format' => 'value',
			'save_custom' => 0,
		),
			array (
				'key' => 'field_570d604a53c64',
				'label' => 'Auto Detect',
				'name' => 'auto_detect',
				'type' => 'checkbox',
				'instructions' => 'Maddos can use external APIs to try to determine these missing values using the Site Url when the post is saved. These take time.',
				'choices' => array (
					'site_icon' => 'Auto Detect Site Icon',
					'mobile_friendly' => 'Auto Detect Mobile Friendliness',
					'screenshot' => 'Auto Detect Screenshot',
					'title' => 'Auto Detect Title',
					'description' => 'Auto Detect Description',
					'tags' => 'Auto Detect Tags',
				),
				'default_value' => array(
					0 => 'site_icon',
					1 => 'mobile_friendly',
					2 => 'screenshot',
					3 => 'title',
					4 => 'description',
					5 => 'tags',
				),
				'layout' => 'horizontal',
			),
			array (
				'key' => 'field_5612c09af2cef',
				'label' => 'Site Icon',
				'name' => 'site_icon',
				'type' => 'text',
				'instructions' => 'Url or html code. Max size will be 16x16.',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5612c0a7f2cf0',
				'label' => 'Mobile Friendly',
				'name' => 'mobile_friendly',
				'type' => 'true_false',
				'instructions' => '',
				'message' => 'If checked a special mobile friendly icon will be shown on the directory page for this post.',
				'default_value' => 0,
			),
			array (
				'key' => 'field_577a76c9f5033',
				'label' => 'Additional Icon',
				'name' => 'additional_icon',
				'type' => 'text',
				'instructions' => 'Url or html code. Max size will be 16x16. This is for any additional groups, such as country flag icons, free vs paid icons, etc.',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
}
}
endif;

?>
