<?php
/*
Plugin Name: Maddos Theme Extensions
Plugin URI: www.superblogme.com/store/products/maddos-directory-theme/
Description: Adds required custom extensions for the Maddos Theme
Author: John Holt
Version: 1.2.7
Author URI: https://www.superblogme.com/
Text Domain: maddos-theme-extensions
*/

define( 'MADDOS_MTE_VERSION', '1.2.7' );

/**
 * Activates Advanced Custom Fields settings
 */
require_once plugin_dir_path( __FILE__ ) . 'maddos-acf.php';

/**
 * Activates custom Maddos Widget
 */
require_once plugin_dir_path( __FILE__ ) . 'maddos-widget.php';



/**
 * Check for WordPress language files
 * Make Maddos available for translation.
 * Translations can be added to the /languages/ directory.
 * load from init instead of after_theme_setup
 * See http://geertdedeckere.be/article/loading-wordpress-language-files-the-right-way
 * and https://ulrich.pogson.ch/load-theme-plugin-translations
 */
function maddos_extensions_language_files() {
	$domain = 'maddos-theme-extensions';
	$locale = apply_filters( 'plugin_locale', get_locale(), $domain );

	// wp-content/languages/plugin-name/plugin-name-de_DE.mo
	load_textdomain( $domain, trailingslashit( WP_LANG_DIR ) . $domain . '/' . $domain . '-' . $locale . '.mo' );
	// wp-content/plugins/plugin-name/languages/plugin-name-de_DE.mo
	load_plugin_textdomain( $domain, FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );

}

add_action( 'init', 'maddos_extensions_language_files' );





//----- PUC functions ---------------------------------------------------------------------
/*
 * Plugin Update Checker
 * Check private server for updates
 * This happens whenever WP checks for updates, default is every 12 hours
 */
function maddos_extensions_check_for_update() {
			
	$beta = apply_filters( 'maddos_theme_extensions_beta', null );
	$url = $beta ? "https://www.superblogme.com/test-update-server/?action=get_metadata&slug=" : "https://www.superblogme.com/wp-update-server/?action=get_metadata&slug=";
	require_once plugin_dir_path( __FILE__ ) . 'plugin-updates/plugin-update-checker.php';
	$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker( 
		$url . 'maddos-theme-extensions', 
		__FILE__, 
		'maddos-theme-extensions' 
	);
	$myUpdateChecker->addQueryArgFilter( 'maddos_extensions_puc' );
		
}

add_action( 'plugins_loaded', 'maddos_extensions_check_for_update' );

function maddos_extensions_puc( $query_args ) {
	$query_args[ 'license' ] = function_exists( 'ot_get_option' ) ? ot_get_option( 'user_id' ) : '';
	$query_args[ 'code' ] = function_exists( 'ot_get_option' ) ? ot_get_option( 'user_code' ) : '';
	return $query_args;
}
