<?php

/**
 * Add Maddos js for Directory Widget
 */

add_action( 'admin_enqueue_scripts', 'maddos_directory_widget_admin_enqueue' );

function maddos_directory_widget_admin_enqueue() {
	wp_enqueue_style( 'maddos-widget-css', plugins_url( '/css/maddos-widget.css', __FILE__ ), null, MADDOS_MTE_VERSION );
	wp_enqueue_script( 'maddos-widget-functions', plugins_url( '/js/maddos-widget.js', __FILE__ ), array( 'jquery' ), MADDOS_MTE_VERSION );
}


/**
 * Add Maddos Widget for Directory pages
 */

add_action( 'widgets_init', function() {
        register_widget( 'maddos_directory_widget' );
});

class maddos_directory_widget extends WP_Widget {

	public function __construct() {
		parent::__construct( 
			'maddos_category', 
			__( 'Maddos Directory', 'maddos-theme-extensions' ),
			array( 
				'classname' => 'maddos_category',
				'description' => __( 'Displays posts by category.', 'maddos-theme-extensions' ), 
			)
		);
	}

	// same as get_categories(), only subcats are listed in proper order under their parents.
	private function get_categories( $instance, $parent_id = 0, $depth = 0 ) {

		$args = array(
			'taxonomy'	=> array( 'category' ),
			'parent'	=> $parent_id,
			'orderby' 	=> 'name',
			'order' 	=> 'ASC',
			'hide_empty' 	=> 0,
			'number'	=> 1000,
			'fields'	=> 'id=>name'
		);
		// this check allows user to modify get_terms
		// user should use $query_args['number'] to change maximum amount to fetch if running out of memory.
		$args = apply_filters( 'maddos_get_terms', $args );

		$term_query = new WP_Term_Query( $args );

		$categories = isset( $term_query->terms ) ? $term_query->terms : array();
		$categories = apply_filters( 'maddos_category_order', $categories, $parent_id, $instance );

		foreach ( $categories as $id => $cat ) {
			$selected = isset( $instance['categories'] ) && in_array( $id, $instance['categories'] ) ? 'checked' : '';
			$prefix = '';
			for( $x=0; $x < $depth; $x++ )
				$prefix = "&mdash; " . $prefix;
			printf( '<input id="%s" name="%s" type="checkbox" value="%s" %s><label for="%s">%s%s</label><br>', 
				esc_attr( $this->get_field_id( 'id' ) ) . $id, 
				esc_attr( $this->get_field_name( 'categories' ) ) . '[]', 
				$id, 
				$selected, 
				esc_attr( $this->get_field_id( 'id' ) ) . $id,
				$prefix,
				$cat
			);
			if ( $id != 0 ) {
				$this->get_categories( $instance, $id, $depth + 1 );
			}
		}
	}

	private function show_pages( $field_name, $field_key ) {
			$pages = get_transient( 'maddos_page_list' );
			if ( empty( $pages ) ) {
				$pages = array( 'none' => 'None', 'category-page' => '[Category Page]' );
				$wp_pages = get_pages();
				foreach ( $wp_pages as $wp_page ) {
					$pages[ $wp_page->ID ] = $wp_page->post_title;
				}
				set_transient( 'maddos_page_list', $pages, 10 );
			}

			printf( '<select class="maddos-widget-option widefat" name="%s">',
				esc_attr( $this->get_field_name( $field_name ) )
			);

			foreach ( $pages as $key => $value ) {
				$selected = $field_key === (string) $key ? 'selected' : '';
				printf( '<option value="%s" %s>%s</option>',
					$key,
					$selected,
					$value
				);
			}
?>
			</select>
<?php
	}

	public function form( $instance ) {

	$instance = wp_parse_args( (array) $instance, 
		apply_filters( 'maddos_widget_defaults', array( 
			'order_by' => 'title',
			'order_dir' => 'ASC',
			'line_options' => array( 'site_icon' => true, 'sticky_icon' => true, 'additional_icon' => true, 'mobile_icon' => true, 'new_icon' => true, 'review_icon' => true, 'hover_thumb' => false )
		) )
	);


?>
		<p class="maddos-widget-field"><strong>Title: </strong>
<?php 
			$value = isset( $instance['title'] ) ? $instance['title'] : '';
			printf( '<input class="maddos-widget-option" id="%s" name="%s" value="%s" size="24">',
				esc_attr( $this->get_field_id( 'title' ) ),
				esc_attr( $this->get_field_name( 'title' ) ),
				$value
			);
?>
		</p>

	<div class="mpw-tabs">
		<a class="mpw-tab-item active" data-toggle="mpw-tab-categories"><?php _e('Categories', 'mpw'); ?></a>
		<a class="mpw-tab-item" data-toggle="mpw-tab-posts"><?php _e('Posts', 'mpw'); ?></a>
		<a class="mpw-tab-item" data-toggle="mpw-tab-display"><?php _e('Display', 'mpw'); ?></a>
	</div>

	<div class="mpw-tab mpw-tab-categories">
<?php

?>
		<strong>Categories to Display</strong>
		<p class="maddos-widget-taxonomy">
<?php
		$this->get_categories( $instance, 0, 0 );
?>
		</p>
		<p class="maddos-widget-field"><strong>CSS class: </strong>
<?php 
			$value = isset( $instance['css_class'] ) ? $instance['css_class'] : '';
			printf( '<input class="maddos-widget-option" name="%s" value="%s" size="12">',
				esc_attr( $this->get_field_name( 'css_class' ) ),
				$value
			);
?>
		</p>
		<p class="maddos-widget-field"><strong>Max Category Height: </strong>
<?php 
			$value = isset( $instance['default_cat_height'] ) ? $instance['default_cat_height'] : '';
			printf( '<input class="maddos-widget-option" name="%s" value="%s" size="4" maxlength="5">',
				esc_attr( $this->get_field_name( 'default_cat_height' ) ),
				$value
			);
?>
		</p>
		<p class="maddos-widget-field"><strong>Show Open/Close icon?</strong>
<?php
			$selected = isset( $instance['open_close_icon'] ) && $instance['open_close_icon'] === 'Yes' ? 'selected' : '';
			printf( '<select class="maddos-widget-option" name="%s">',
				esc_attr( $this->get_field_name( 'open_close_icon' ) ) 
			);
?>
			<option value="No">No</option>
			<option value="Yes" <?php echo esc_attr( $selected );?>>Yes</option>
			</select>
		</p>
		<p class="maddos-widget-field"><strong>Show Descriptions?</strong>
<?php
			$value = isset( $instance['cat_desc'] ) ? $instance['cat_desc'] : '';
			printf( '<select class="maddos-widget-option" name="%s">',
				esc_attr( $this->get_field_name( 'cat_desc' ) ) 
			);
?>
			<option value="none">No</option>
			<option value="full" <?php if ( $value === 'full' ) echo 'selected';?>>Yes</option>
			<option value="sentence" <?php if ( $value === 'sentence' ) echo 'selected';?>>1st sentence</option>
			</select>
		</p>
		<p class="maddos-widget-field"><strong>Link Title to Page?</strong>
<?php
			$selected = isset( $instance['link_cat_title'] ) ? $instance['link_cat_title'] : null;
			$this->show_pages( 'link_cat_title', $selected );
?>
		</p>
	</div>

	<div class="mpw-tab mpw-tab-posts mpw-hide">
		<p class="maddos-widget-field"><strong>Order Posts By: </strong>
<?php
			$value = isset( $instance['order_by'] ) ? $instance['order_by'] : '';
			printf( '<select class="maddos-widget-option" name="%s">',
				esc_attr( $this->get_field_name( 'order_by' ) ) 
			);
?>
			<option value="author" <?php if ( $value === 'author' ) echo 'selected';?>>Author</option>
			<option value="comment_count" <?php if ( $value === 'comment_count' ) echo 'selected';?>>Comment Count</option>
			<option value="date" <?php if ( $value === 'date' ) echo 'selected';?>>Date</option>
			<option value="ID" <?php if ( $value === 'ID' ) echo 'selected';?>>Post ID</option>
			<option value="modified" <?php if ( $value === 'modified' ) echo 'selected';?>>Modified</option>
			<option value="none" <?php if ( $value === 'none' ) echo 'selected';?>>None</option>
			<option value="parent" <?php if ( $value === 'parent' ) echo 'selected';?>>Parent</option>
			<option value="rand" <?php if ( $value === 'rand' ) echo 'selected';?>>Random</option>
			<option value="title" <?php if ( $value === 'title' ) echo 'selected';?>>Title</option>
			</select>
		</p>
		<p class="maddos-widget-field"><strong>Order Posts Direction: </strong>
<?php
			$value = isset( $instance['order_dir'] ) ? $instance['order_dir'] : '';
			printf( '<select class="maddos-widget-option" name="%s">',
				esc_attr( $this->get_field_name( 'order_dir' ) ) 
			);
?>
			<option value="DESC">Descending</option>
			<option value="ASC" <?php if ( $value === 'ASC' ) echo 'selected';?>>Ascending</option>
			</select>
		</p>
		<p class="maddos-widget-field"><strong>Max Posts to Show: </strong>
<?php 
			$value = isset( $instance['max_posts'] ) ? $instance['max_posts'] : '';
			printf( '<input class="maddos-widget-option" name="%s" value="%s" size="4" maxlength="5">',
				esc_attr( $this->get_field_name( 'max_posts' ) ),
				$value
			);
?>
		</p>
		<p class="maddos-widget-field"><strong>Link 'See all X sites' to Page?</strong>
<?php
			$selected = isset( $instance['link_more_sites'] ) ? $instance['link_more_sites'] : null;
			$this->show_pages( 'link_more_sites', $selected );
?>
		</p>
	</div>

	<div class="mpw-tab mpw-tab-display mpw-hide">
		<p><strong>Link Post to: </strong>
<?php
			$value = isset( $instance['link_to'] ) ? $instance['link_to'] : '';
			printf( '<select class="maddos-widget-option" name="%s">',
				esc_attr( $this->get_field_name( 'link_to' ) ) 
			);
?>
			<option value="site_url">Site Url</option>
			<option value="post_url" <?php if ( $value === 'post_url' ) echo 'selected';?>>Post Url</option>
			</select>
		</p>
		<p><strong>Link Options: </strong><br>
<?php
			$value = isset( $instance['link_options'] ) ? $instance['link_options'] : array();
			$selected = isset( $value['new_tab'] ) && ! empty( $value['new_tab'] ) ? 'checked' : '';
			printf( '<label>%s</label><input type="checkbox" class="maddos-widget-option" name="%s" value="%s" %s><br>',
				"New Tab",
				esc_attr( $this->get_field_name( 'link_options' ) ) . '[new_tab]',
				true,
				$selected
			);
			$selected = isset( $value['no_follow'] ) && ! empty( $value['no_follow'] ) ? 'checked' : '';
			printf( '<label>%s</label><input type="checkbox" class="maddos-widget-option" name="%s" value="%s" %s><br>',
				"No Follow",
				esc_attr( $this->get_field_name( 'link_options' ) ) . '[no_follow]',
				true,
				$selected
			);
?>
		</p>
		<p><strong>Line Options: </strong><br>
<?php
			$value = isset( $instance['line_options'] ) ? $instance['line_options'] : array();
			$selected = isset( $value['site_icon'] ) && ! empty( $value['site_icon'] ) ? 'checked' : '';
			printf( '<label>%s</label><input type="checkbox" class="maddos-widget-option" name="%s" value="%s" %s><br>',
				"Show Site Icon",
				esc_attr( $this->get_field_name( 'line_options' ) ) . '[site_icon]',
				true,
				$selected
			);
			$selected = isset( $value['sticky_icon'] ) && ! empty( $value['sticky_icon'] ) ? 'checked' : '';
			printf( '<label>%s</label><input type="checkbox" class="maddos-widget-option" name="%s" value="%s" %s><br>',
				"Show Sticky Icon",
				esc_attr( $this->get_field_name( 'line_options' ) ) . '[sticky_icon]',
				true,
				$selected
			);
			$selected = isset( $value['additional_icon'] ) && ! empty( $value['additional_icon'] ) ? 'checked' : '';
			printf( '<label>%s</label><input type="checkbox" class="maddos-widget-option" name="%s" value="%s" %s><br>',
				"Show Additional Icon",
				esc_attr( $this->get_field_name( 'line_options' ) ) . '[additional_icon]',
				true,
				$selected
			);
			$selected = isset( $value['mobile_icon'] ) && ! empty( $value['mobile_icon'] ) ? 'checked' : '';
			printf( '<label>%s</label><input type="checkbox" class="maddos-widget-option" name="%s" value="%s" %s><br>',
				"Show Mobile Icon",
				esc_attr( $this->get_field_name( 'line_options' ) ) . '[mobile_icon]',
				true,
				$selected
			);
			$selected = isset( $value['new_icon'] ) && ! empty( $value['new_icon'] ) ? 'checked' : '';
			printf( '<label>%s</label><input type="checkbox" class="maddos-widget-option" name="%s" value="%s" %s><br>',
				"Show New Icon",
				esc_attr( $this->get_field_name( 'line_options' ) ) . '[new_icon]',
				true,
				$selected
			);
			$selected = isset( $value['review_icon'] ) && ! empty( $value['review_icon'] ) ? 'checked' : '';
			printf( '<label>%s</label><input type="checkbox" class="maddos-widget-option" name="%s" value="%s" %s><br>',
				"Show Review Icon on hover",
				esc_attr( $this->get_field_name( 'line_options' ) ) . '[review_icon]',
				true,
				$selected
			);
			$selected = isset( $value['hover_thumb'] ) && ! empty( $value['hover_thumb'] ) ? 'checked' : '';
			printf( '<label>%s</label><input type="checkbox" class="maddos-widget-option" name="%s" value="%s" %s><br>',
				"Show Thumbnail on hover",
				esc_attr( $this->get_field_name( 'line_options' ) ) . '[hover_thumb]',
				true,
				$selected
			);
?>
		<p class="maddos-widget-field"><strong>Days to show New Icon: </strong>
<?php 
			$value = isset( $instance['new_icon_days'] ) ? $instance['new_icon_days'] : '3';
			printf( '<input class="maddos-widget-option" name="%s" value="%s" size="4" maxlength="5">',
				esc_attr( $this->get_field_name( 'new_icon_days' ) ),
				$value
			);
?>
		</p>
	</div>
	<p>&nbsp;</p>
<?php
	}

	public function update( $new_instance, $old_instance ) {

		// need to set 'false' defaults since WP won't attach 'false' fields to instance
		$new_instance['line_options'] = isset( $new_instance['line_options'] ) ? $new_instance['line_options'] : array( 'site_icon' => false, 'sticky_icon' => false, 'additional_icon' => false, 'mobile_icon' => false, 'new_icon' => false, 'review_icon' => false, 'hover_thumb' => false );

		return $new_instance;
	}

	public function widget( $args, $instance ) {

		$categories = isset( $instance['categories'] ) ? $instance['categories'] : array();
		$categories = apply_filters( 'maddos_categories_widget', $categories, $instance );
		if ( empty( $categories ) )  return;

		// Categories
		$css_class = isset( $instance['css_class'] ) ? $instance['css_class'] : '';
		$default_cat_height = isset( $instance['default_cat_height'] ) ? $instance['default_cat_height'] : '';
		$link_cat_title = isset( $instance['link_cat_title'] ) ? $instance['link_cat_title'] : '';
		$open_close_icon = isset( $instance['open_close_icon'] ) ? $instance['open_close_icon'] : '';
		$cat_desc = isset( $instance['cat_desc'] ) ? $instance['cat_desc'] : '';

		// Posts
		$max_posts = isset( $instance['max_posts'] ) ? $instance['max_posts'] : '-1';
		if ( empty( $max_posts ) && $max_posts !== '0' ) $max_posts = -1;
		$link_more_sites = isset( $instance['link_more_sites'] ) ? $instance['link_more_sites'] : '';
		$order_by = isset( $instance['order_by'] ) ? $instance['order_by'] : 'title';
		$order_dir = isset( $instance['order_dir'] ) ? $instance['order_dir'] : 'DESC';

		// Display
		$link_to = isset( $instance['link_to'] ) ? $instance['link_to'] : 'DESC';
		$link_options = isset( $instance['link_options'] ) ? $instance['link_options'] : array();
		$line_options = isset( $instance['line_options'] ) ? $instance['line_options'] : array();
		$new_icon_days = isset( $instance['new_icon_days'] ) ? $instance['new_icon_days'] : '3';

		$template_uri = get_template_directory_uri();

		foreach ( $categories as $category_id ) {

			$term = get_category( $category_id );

			if ( is_wp_error( $term ) ) continue;

			$save_order = false;
?>
			<aside class="widget maddos-widget <?php echo sanitize_html_class( $css_class );?>">

				<div class="maddos-widget-title maddos-category-header" id="<?php echo esc_html( $term->slug );?>">

				<?php $cat_icon = function_exists( 'get_field' ) ? get_field('cat_icon', 'category_'.$term->term_id) : null; 
				if ( filter_var( $cat_icon, FILTER_VALIDATE_URL ) ) : ?>
					<span class="maddos-category-icon"><img alt="<?php echo esc_html( $term->name );?>" title="<?php echo esc_html( $term->name ); ?>" src="<?php echo wp_kses_post( $cat_icon );?>" /></span>
				<?php elseif ( $cat_icon ) : ?>
					<span class='maddos-category-icon'><?php echo wp_kses_post( $cat_icon );?></span>
				<?php endif; ?>

				<?php
					$cat_link = null;
					if ( $link_cat_title == 'category-page' ) {
						$cat_link = get_term_link( $term );
					}
					else if ( is_numeric( $link_cat_title ) ) {
						$cat_link = get_permalink( $link_cat_title );
					}
					$cat_link = apply_filters( 'maddos_category_link', $cat_link, $link_cat_title );
						
					if ( $cat_link ) {
						$cat_title = apply_filters( 'maddos_category_name', $term->name );
						$title = sprintf( '<a href="%s">%s</a>',
							esc_url( $cat_link ),
							esc_html( $cat_title )
						);
					}
					else {
						$title = esc_html( $term->name );
					}
					$title = apply_filters( 'maddos_category_title', $title, $term );
				?>
				<h3 class="maddos-category-header-title"><?php echo $title;?></h3>

				<?php if ( $open_close_icon === 'Yes' ) : ?>
				<div class="maddos-open-close-button open"></div>
				<?php endif; ?>
				</div>

				<?php 
					$cat_height = function_exists( 'get_field' ) ? get_field('cat_height', 'category_'.$term->term_id) : null;
					$height = $cat_height ? $cat_height : $default_cat_height;
				?>
				<?php $style = $height ?  'style="max-height:'.$height.'px;"' : ''; ?>
				<div class="maddos-category-wrapper" <?php echo htmlspecialchars( $style, ENT_NOQUOTES );?> id="<?php echo esc_html( $term->slug );?>-list">
				<?php
				$description = category_description( $category_id );
				$description = maddos_taxonomy_description( $description, $category_id, $cat_desc );
				if ( ! empty ( $description ) ) {
					echo '<div class="maddos-taxonomy-description">' . $description . '</div>';
				}

				if ( $max_posts != 0 ) {

				?>

				<ol>
<?php
				if ( $order_by === 'alexaRank' ) {
					$order_by = 'none';
				}

				if ( $order_by === 'none' ) {	// order must be set to 'none' for Intuitive Custom Posts Order to work
					$args = array( 'posts_per_page' => -1, 'cat' => $term->term_id );
				}
				else {
					$args = array( 'posts_per_page' => -1, 'cat' => $term->term_id, 'orderby' => $order_by, 'order' => $order_dir );
				}

				$args = apply_filters( 'maddos_directory_posts', $args );

if ( function_exists( 'maddos_debug_msg' ) ) maddos_debug_msg( "MTE directory posts WP_Query args: " . print_r($args,true ) );

				$the_query = new WP_Query( $args );

if ( function_exists( 'maddos_debug_msg' ) ) maddos_debug_msg( "MTE directory posts found overall total of {$the_query->found_posts} results from WP_Query" );
if ( function_exists( 'maddos_debug_msg' ) ) maddos_debug_msg( "MTE directory posts results from WP_Query: post IDs " . implode( ',', wp_list_pluck( $the_query->posts, 'ID' ) ) );

				if ( $the_query->have_posts() ) {
					$post_count = 0;
				while ( $the_query->have_posts() ) {
					$the_query->the_post();
					$title = get_the_title();
					$postID = get_the_ID();

					$options = apply_filters( 'maddos_single_post_options', get_post_meta( $postID, 'options', true ), $postID );
					if ( is_array( $options ) && false !== array_search( 'exclude_post', $options ) ) {
						continue;
					}
					$post_count++;

					$icon = isset( $line_options['site_icon'] ) && ! empty( $line_options['site_icon'] ) && function_exists( 'get_field' ) ? get_field( 'site_icon', $postID ) : null ;
					$icon = apply_filters( 'maddos_site_icon', $icon, $postID );
					// in case site switched to ssl but still using http links:
					if ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') ||
    $_SERVER['SERVER_PORT'] == 443) {
						$icon = str_replace( 'http:', 'https:', $icon );
					}
					$site_icon = $icon && filter_var( $icon, FILTER_VALIDATE_URL ) ? "<span class='maddos-icon site-icon'><img width='16' height='16' alt='{$title}' title='{$title}' src='{$icon}' /></span>" : "<span class='maddos-icon site-icon'>{$icon}</span>"; 

					$site_url = function_exists( 'get_field' ) ? get_field( 'site_url', $postID ) : null;
					$site_url = apply_filters( 'maddos_get_site_url', $site_url, $postID );
					$href = $site_url && $link_to === 'site_url' ? $site_url : get_permalink();
					$href = apply_filters( 'maddos_directory_post_href', $href, $site_url, $postID );
					$target = isset( $link_options['new_tab'] ) && ! empty( $link_options['new_tab'] ) ? maddos_get_target( true ) : maddos_get_target( false );

					$rel = isset( $link_options['no_follow'] ) && ! empty( $link_options['no_follow'] ) ? maddos_get_rel( true, $target ) : maddos_get_rel( false, $target );

					$mobile_icon = isset( $line_options['mobile_icon'] ) && ! empty( $line_options['mobile_icon'] ) && function_exists( 'get_field' ) && get_field( 'mobile_friendly', $postID ) ? ' <span class="maddos-mobile-friendly-icon"></span>' : '';

					$sticky_icon = isset( $line_options['sticky_icon'] ) && ! empty( $line_options['sticky_icon'] ) && is_sticky( $postID ) ? ' <span class="maddos-sticky-icon"></span>' : '';

					$add_icon = isset( $line_options['additional_icon'] ) && ! empty( $line_options['additional_icon'] ) && function_exists( 'get_field' ) ? get_field( 'additional_icon', $postID ) : null;
					$additional_icon = $add_icon ? filter_var( $add_icon, FILTER_VALIDATE_URL ) ? " <span class='maddos-icon additional-icon'><img width='16' height='16' alt='{$title}' title='{$title}' src='{$add_icon}' /></span>" : " <span class='maddos-icon additional-icon'>{$add_icon}</span>" : ''; 
					$additional_icon = apply_filters( 'maddos_get_additional_icon', $additional_icon, $postID );

					$age = ( time() - strtotime( get_the_date() ) ) / 86400;
					$new_icon = isset( $line_options['new_icon'] ) && ! empty( $line_options['new_icon'] ) && $age <= $new_icon_days ? ' <span class="maddos-new-icon"></span>' : '';

					$hover = isset( $line_options['hover_thumb'] ) && ! empty( $line_options['hover_thumb'] ) && has_post_thumbnail( $postID ) ? get_the_post_thumbnail( $postID, 'hover-thumb', array('class'=>'img-responsive maddos-image-hover', 'alt' => $title, 'title' => $title ) ) : '';

					$review_link = apply_filters( 'maddos_get_review_link', get_permalink(), $postID );
					$review_icon = isset( $line_options['review_icon'] ) && ! empty( $line_options['review_icon'] ) && apply_filters( 'the_content', get_the_content() ) ? "<div class='maddos-review'><a href='" . $review_link . "'><span class='maddos-site-review-icon'></span></a></div>" : '';

					$review_icon = apply_filters( 'maddos_get_review_icon', $review_icon, $postID );

					$out_args = array(
						'site_icon'		=> $site_icon,
						'title'			=> $title,
						'target'		=> $target,
						'rel'			=> $rel,
						'href'			=> $href,
						'sticky_icon'		=> $sticky_icon,
						'additional_icon'	=> $additional_icon,
						'mobile_icon'		=> $mobile_icon,
						'new_icon'		=> $new_icon,
						'hover_thumb'		=> $hover,
						'review_icon'		=> $review_icon
					);
					$output = sprintf( '%s <a class="maddos-link" title="%s" %s %s href="%s">%s %s %s %s %s %s</a> %s', $site_icon, $title, $target, $rel, $href, $title, $sticky_icon, $additional_icon, $mobile_icon, $new_icon, $hover, $review_icon );
					$output = apply_filters( 'maddos_category_post_output', $output, $postID, $out_args );
					printf( '<li>%s</li>', $output );

					if ( $max_posts > 0 && $post_count >= $max_posts ) break;
				} // end while have_posts

				} // end if have_posts 
				wp_reset_postdata();?>
				</ol>
<?php

				// possible link to cat page if max_posts option is used
				$show_total_posts = 0;
				if ( $max_posts >= 0 && $post_count >= $max_posts && $the_query->found_posts ) {
#MARK what about excluded from Dir posts?
					$diff = $the_query->found_posts - $post_count;
					$show_total_posts = $the_query->found_posts;
					$more_link = null;
					if ( $link_more_sites === 'category-page' ) {
						$more_link = get_term_link( $term );
					}
					else if ( is_numeric( $link_more_sites ) ) {
						$more_link = get_permalink( $link_more_sites );
					}
					$link = sprintf( '<a href="%s">%s %s</a>',
							esc_url( $more_link),
							esc_html( 'See all' ),
							esc_attr( $show_total_posts ) . " sites"
						);
					$link = apply_filters( 'maddos_see_more_link', $link, $term );
				}

?>
				</div>
<?php if ( $show_total_posts && $link ) : ?>
				<div class="maddos-more-link">
					<?php echo $link; ?>
				</div>
<?php
endif; 
				} // end if max_posts != 0
?>
			</aside>
	<?php 	}
	}
}


