<?php

/*
 * Add Maddos alexa event hook if needed
 */
add_action( 'after_setup_theme', 'maddos_alexa_setup' );
function maddos_alexa_setup() {
        // need to schedule alexa daily event?
	$time_in_secs = apply_filters( 'maddos_alexa_event_time', 86400 );
        if (! wp_next_scheduled ( 'alexa_daily_event' )) {
                wp_schedule_single_event( time() + $time_in_secs, 'alexa_daily_event' );
        }
}

/*
 * Remove Maddos alexa event hook when theme is changed to another.
 */
add_action('switch_theme', 'maddos_on_theme_switch');
function maddos_on_theme_switch() {
        wp_clear_scheduled_hook( 'alexa_daily_event' );
}

/*
 * Alexa daily event, update Alexa Rank of all published posts 
 */
add_action('alexa_daily_event', 'maddos_alexa_daily_check');
if ( ! function_exists( 'maddos_alexa_daily_check' ) ) :
function maddos_alexa_daily_check() {
	maddos_extend_execution_time();
	$args = array( 'posts_per_page' => -1, 'fields' => 'ids', 'orderby' => 'rand' );
	$args = apply_filters( 'maddos_alexa_daily_event', $args );
	$posts = new WP_Query( $args );
	while ( $posts->have_posts() ) {
		$posts->the_post();
		$postID = get_the_ID();
		if ( ! $postID ) continue;
		maddos_alexa_info( $postID, false );
  		$site_url = function_exists( 'get_field' ) ? get_field( 'site_url', $postID ) : null;
		if ( ! $site_url ) continue;
		sleep(1); // don't slam the alexa API
	}
}
endif;


/*
 * Query the Alexa API and update Alexa Rank for a post. Optionally echo to screen, like the post edit page.
 */
if ( ! function_exists( 'maddos_alexa_info' ) ) :
function maddos_alexa_info( $post_id, $echo = false ) {
	// do we have a valid site_url?
  	$site_url = function_exists( 'get_field' ) ? get_field( 'site_url', $post_id ) : null;

	$debug = apply_filters( 'maddos_debug', false, $site_url );

	if ( ! $site_url ) return;

	if ( $debug == 'alexa' ) maddos_add_admin_notice("<div class='notice notice-warning'><p>DEBUG: Maddos Alexa site_url is " . $site_url . "</p></div>" );

	// handle any cloaks or redirects to get true url
       	$link = maddos_site_url_check( $site_url, false );
	if ( ! $link ) return;

	$link = apply_filters( 'maddos_url_alexa_override', $link );

       	$parse = parse_url( $link );
	$link = isset( $parse['host'] ) ? $parse['host'] : $link;

	// check for domain exclusions
	$exclusions = apply_filters( 'maddos_alexa_exclusions', array() );
	foreach ( $exclusions as $exclude ) {
		if ( false !== stripos( $link, $exclude ) ) {
			if ( true === $echo ) {
				echo __( "Alexa (this domain is excluded)", 'maddos' ) . "<br><br>";
			}
			delete_post_meta( $post_id, 'alexaRank' );
			return;
		}
	}

	$alexa = "http://data.alexa.com/data?cli=10&url=" . $link;
	if ( $debug == 'alexa' ) maddos_add_admin_notice("<div class='notice notice-warning'><p>DEBUG: Maddos calling Alexa with " . $alexa . "</p></div>" );

	$response =  wp_remote_get( $alexa );
  	if ( is_wp_error( $response ) || ! isset( $response['body'] ) ) {
		$msg = sprintf( __( "%s WP Error on %s: %s", 'maddos' ), __FUNCTION__, $alexa, $response->get_error_message() );
		if ( $echo ) maddos_add_admin_notice( "<div class='error'><p>" . $msg . "</p></div>" );
		else error_log( $msg );
		return;
	}

	$data = apply_filters( 'maddos_alexa_response', wp_remote_retrieve_body( $response ) );

	if ( $data === 'Okay' ) { // Ip has been blacklisted
		$msg = sprintf( __( "%s Alexa returned: %s - This means your IP is on its blacklist.", 'maddos' ), __FUNCTION__, $data );
		if ( $echo ) maddos_add_admin_notice( "<div class='error'><p>" . $msg . "</p></div>" );
		else error_log( $msg );
		return;
	}

	$xml = $data ? simplexml_load_string( $data, 'SimpleXMLElement', LIBXML_NOWARNING | LIBXML_NOERROR ) : null;

	if ( ! $xml && is_admin() ) {
		$msg = sprintf( __( '%s - Failed to get an API response from Alexa for site statistics on %s. Will automatically try again tomorrow.', 'maddos' ), __FUNCTION__, $alexa );
		if ( $echo ) maddos_add_admin_notice( "<div class='notice notice-warning'><p>" . $msg . "</p></div>" );
		else error_log( $msg );
		return;
	}

	if ( $debug == 'alexa' ) maddos_add_admin_notice("<div class='notice notice-warning'><p>DEBUG: Maddos Alexa returned: " . print_r($xml,true) . "</p></div>" );

	if ( $post_id && $link && $xml && isset( $xml->SD ) ) {
		$pop = $xml->SD->POPULARITY ? $xml->SD->POPULARITY->attributes() : null;
		$country = $xml->SD->COUNTRY ? $xml->SD->COUNTRY->attributes() : null;
		if ( true === $echo ) {
			$arank = "<strong>";
			if ( ! empty ( $pop ) ) $arank .= __( 'Global Rank: ', 'maddos' ) . $pop['TEXT'] . ". ";
			if ( ! empty( $country ) ) $arank .= __( 'Rank in ', 'maddos' ) . strval( $country['NAME'] ) . ": " . strval( $country['RANK'] );
			$arank .= "</strong><br><br>\n";

			printf( "<a target='blank' href='%s'>Alexa</a> %s",
				esc_url( 'http://www.alexa.com/siteinfo/' . $link ),
				$arank
			);
		}
	}

	// save in custom meta field in case user wants to use it
	$newRank = isset( $pop ) && ! empty ( $pop ) ? (int) $pop['TEXT'] : 999999999;
	add_post_meta( $post_id, 'alexaRank', $newRank, true ) || update_post_meta( $post_id, 'alexaRank', $newRank );
}
endif;


?>
