<?php
/**
 * Initialize the custom Theme Options for Maddos.
 */
add_action( 'admin_init', 'custom_theme_options' );

/**
 * Build the custom settings & update OptionTree.
 *
 * @return    void
 * @since     2.3.0
 */
function custom_theme_options() {
  
  /* OptionTree is not loaded yet */
  if ( ! function_exists( 'ot_settings_id' ) )
    return false;
  
  /**
   * Get a copy of the saved settings array. 
   */
  $saved_settings = get_option( ot_settings_id(), array() );

  /**
   * Custom settings array that will eventually be 
   * passed to the OptionTree Settings API Class.
   */

  $custom_settings = array(

/* ------------------------------------ 
 Theme Option Sections 
 ------------------------------------ */
	'sections'	=> array(
		array(
			'id'		=> 'general-options',
			'title'		=> __( 'General Options', 'maddos' )
		),
		array(
			'id'		=> 'header-options',
			'title'		=> __( 'Header Options', 'maddos' )
		),
		array(
			'id'		=> 'menu-options',
			'title'		=> __( 'Menu Options', 'maddos' )
		),
		array(
			'id'		=> 'archive-options',
			'title'		=> __( 'Archive Options', 'maddos' )
		),
		array(
			'id'		=> 'post-options',
			'title'		=> __( 'Post Options', 'maddos' )
		),
		array(
			'id'		=> 'related-options',
			'title'		=> __( 'Related Posts Options', 'maddos' )
		),
		array(
			'id'		=> 'footer-options',
			'title'		=> __( 'Footer Options', 'maddos' )
		),
		array(
			'id'		=> 'custom-css',
			'title'		=> __( 'Custom CSS', 'maddos' )
		),
		array(
			'id'		=> 'license',
			'title'		=> __( 'License', 'maddos' )
		)
	),

	'settings'        => array(
/* ------------------------------------ 
 General Options 
 ------------------------------------ */
                array(
                        'id'		=> 'documentation_text',
                        'label'		=> sprintf( __('Maddos %s Documentation & Support', 'maddos'), MADDOS_VERSION ),
                        'desc'		=> sprintf( __('Maddos documentation is <a target="_blank" href="%s">here</a>.<br>You can contact support <a target="_blank" href="%s">here</a>.<br>Maddos changelog is <a target="_blank" href="%s">here</a>.', 'maddos' ), 'https://www.superblogme.com/maddos-theme-documentation/', 'https://www.superblogme.com/contact-me/', 'https://www.superblogme.com/maddos-theme-changelog/' ),
                        'desc'		=> sprintf( __('<a target="_blank" class="button button-primary" href="%s">Maddos Documentation</a> &nbsp; <a target="_blank" class="button button-primary" href="%s">Maddos Support</a> &nbsp; <a target="_blank" class="button button-primary" href="%s">Maddos Changelog</a>', 'maddos' ), 'https://www.superblogme.com/maddos-theme-documentation/', 'https://www.superblogme.com/contact-me/', 'https://www.superblogme.com/maddos-theme-changelog/' ),
                        'type'		=> 'textblock-titled',
                        'section'	=> 'general-options',
                ),
                array(
			'id'		=> 'load_fontawesome',
                        'label'		=> __('Load Font Awesome', 'maddos'),
                        'desc'		=> sprintf(__( 'Load the <a target="_blank" href="%s">Font Awesome</a> icon library to use in Maddos.', 'maddos'), "https://fontawesome.com/" ),
                        'std'           => 'on',
                        'type'          => 'on-off',
                        'section'	=> 'general-options',
                ),
		array(
			'id'		=> 'grid_option',
			'label'		=> __( 'Bootstrap Grid Option', 'maddos' ),
			'desc'		=> __( 'Determines the key breakpoints in the responsive grid system. This means on devices smaller than the selected option, the bootstrap grid will collapse to a single column. If changed, you may want to also change some of the values in responsive.css', 'maddos' ),
			'std'		=> 'col-md-',
			'type'		=> 'select',
			'section'	=> 'general-options',
			'choices'	=> array(
				array(
					'value' => 'col-xs-',
					'label' => 'Extra small devices (Phones < 576px)'
				),
				array(
					'value' => 'col-sm-',
					'label' => 'Small devices (Tablets >= 576px)'
				),
				array(
					'value' => 'col-md-',
					'label' => 'Medium devices (Desktops >= 768px)'
				),
				array(
					'value' => 'col-lg-',
					'label' => 'Large devices (Desktops >= 992px)'
				),
				array(
					'value' => 'col-xl-',
					'label' => 'Extra large devices (Desktops >= 1200px)'
				),
			),
		),
		array(
			'id'		=> 'site_background',
			'label'		=> __( 'Site Background Color/Image', 'maddos' ),
			'desc'		=> __( 'Change the background values for the site. This has more options than using the WordPress Appearance -> Background.', 'maddos' ),
			'type'		=> 'background',
			'section'	=> 'general-options',
		),
		array(
			'id'		=> 'site_primary',
			'label'		=> __( 'Site Primary Color', 'maddos' ),
			'desc'		=> __( 'Change the primary color values for the site.', 'maddos' ),
			'type'		=> 'colorpicker-opacity',
			'section'	=> 'general-options',
			'std'		=> '#000000',
		),
		array(
			'id'		=> 'site_secondary',
			'label'		=> __( 'Site Secondary Color', 'maddos' ),
			'desc'		=> __( 'Change the secondary color values for the site.', 'maddos' ),
			'type'		=> 'colorpicker-opacity',
			'section'	=> 'general-options',
			'std'		=> '#aa0000',
		),
		array(
			'id'		=> 'site_google_fonts',
			'label'		=> __( 'Load Google Fonts', 'maddos' ),
			'desc'		=> sprintf(__( 'Which <a target="_blank" href="%s">Google Fonts</a> to enable for use in the site typographies and custom css. You must save these values before the Google fonts will display in any typography dropboxes.', 'maddos'), "https://www.google.com/fonts" ),
			'type'		=> 'google-fonts',
			'section'	=> 'general-options',
		),
		array(
			'id'		=> 'category_typography',
			'label'		=> __( 'Site Primary Typography', 'maddos' ),
			'desc'		=> __( 'Change the default primary typography for the site. This is the Site Title, Widget Titles, single Post Title, etc.', 'maddos' ),
			'type'		=> 'typography',
			'section'	=> 'general-options',
		),
		array(
			'id'		=> 'site_typography',
			'label'		=> __( 'Site Secondary Typography', 'maddos' ),
			'desc'		=> __( 'Change the default secondary typopgraphy for the site.', 'maddos' ),
			'type'		=> 'typography',
			'section'	=> 'general-options',
		),
		array(
			'id'		=> 'site_anchor_colors',
			'label'		=> __( 'Site Anchor Link Colors', 'maddos' ),
			'desc'		=> __( 'Change the default anchor link colors to use throughout the site.', 'maddos' ),
			'type'		=> 'link-color',
			'section'	=> 'general-options',
		),
		array(
			'id'		=> 'site_boxshadow',
			'label'		=> __( 'Site Box Shadows', 'maddos' ),
			'desc'		=> __( 'Change the default box shadows to use throughout the site.', 'maddos' ),
			'type'		=> 'box-shadow',
			'section'	=> 'general-options',
		),
                array(
			'id'		=> 'use-text-shadow',
                        'label'		=> __('Use Text Shadow', 'maddos'),
                        'desc'		=> __('Will show a shadow behind most texts to make them more visible against certain backgrounds.', 'maddos'),
                        'std'           => 'off',
                        'type'          => 'on-off',
                        'section'	=> 'general-options',
                ),
/* ------------------------------------ 
 Header Options 
 ------------------------------------ */
		array(
			'id'            => 'infobar_text',
			'label'         => __( 'Info Bar Text', 'maddos' ),
			'desc'          => __( 'The text shown in the info bar. If not specified, the info bar will not be displayed.', 'maddos' ), 
			'std'           => '',
			'type'          => 'text',
			'section'       => 'header-options',
		),
		array(
			'id'		=> 'infobar_background',
			'label'		=> __( 'Info Bar Background', 'maddos' ),
			'desc'		=> __( 'Change the background values for the info bar.', 'maddos' ),
			'type'		=> 'background',
			'section'	=> 'header-options',
			'condition'	=> 'infobar_text:not()'
		),
		array(
			'id'		=> 'infobar_typography',
			'label'		=> __( 'Info Bar Typography', 'maddos' ),
			'desc'		=> __( 'Change the default typography for the info bar.', 'maddos' ),
			'type'		=> 'typography',
			'section'	=> 'header-options',
			'condition'	=> 'infobar_text:not()'
		),
                array(
			'id'		=> 'custom_header_image',
                        'label'		=> __('Custom Header Image', 'maddos'),
                        'desc'		=> __('To add or randomize header images, use the WordPress Appearance-&gt;Header menu option. <br>The recommended size is 1140x200 and will automatically resize as needed', 'maddos'),
                        'type'		=> 'textblock-titled',
                        'section'	=> 'header-options',
                ),
                array(
			'id'		=> 'link_header_image',
                        'label'		=> __('Link Header Image', 'maddos'),
                        'desc'		=> __('Will link the header image to the home page.', 'maddos'),
                        'std'           => 'off',
                        'type'          => 'on-off',
                        'section'	=> 'header-options',
                ),
                array(
			'id'		=> 'show_header_content',
                        'label'		=> __('Show Header Content', 'maddos'),
                        'desc'		=> __('Will show the header content (Site Title and Description). If using a header image, this text will overlay it.', 'maddos'),
                        'std'           => 'on',
                        'type'          => 'on-off',
                        'section'	=> 'header-options',
                ),
                array(
			'id'		=> 'header_content_offset',
                        'label'		=> __('Header Content Offset', 'maddos'),
                        'desc'		=> __('You can specify the offset of the Header Content.', 'maddos'),
                        'type'		=> 'spacing',
			'std'		=> array( 'top' => 10, 'left' => 10 ),
                        'section'	=> 'header-options',
			'condition'	=> 'show_header_content:is(on)'
                ),
		array(
			'id'		=> 'site_title_typography',
			'label'		=> __( 'Site Title Typography', 'maddos' ),
			'desc'		=> __( 'Change the default typopgraphy for the site title, overwriting the Primary Typography.', 'maddos' ),
			'type'		=> 'typography',
			'section'	=> 'header-options',
			'condition'	=> 'show_header_content:is(on)'
		),
		array(
			'id'		=> 'site_desc_typography',
			'label'		=> __( 'Site Description Typography', 'maddos' ),
			'desc'		=> __( 'Change the default typopgraphy for the site description, overwriting the Secondary Typography.', 'maddos' ),
			'type'		=> 'typography',
			'section'	=> 'header-options',
			'condition'	=> 'show_header_content:is(on)'
		),
                array(
                        'id'            => 'header_show_searchform',
                        'label'         => __( 'Show Search Form', 'maddos' ),
                        'desc'          => __( 'Display the search form in the header. Use custom css for class "maddos-search" to change exact location.', 'maddos' ),
                        'std'           => 'on',
                        'type'          => 'on-off',
                        'section'       => 'header-options'
                ),
		array(
			'id'            => 'headline_text',
			'label'         => __( 'Headline Text', 'maddos' ),
			'desc'          => __( 'Text shown below the header image. If not specified, no headline will be shown.', 'maddos' ), 
			'std'           => '',
			'type'          => 'text',
			'section'       => 'header-options',
		),
                array(
                        'id'          => 'header_widget_area',
                        'label'       => __('Header Widget Area', 'maddos'),
                        'desc'        => __('To edit the header area widgets, use the WordPress Appearance-&gt;Widgets menu option. It acts just like a full width sidebar. You can use it to display a text widget, ad widget, carousel widget, etc.', 'maddos' ),
                        'type'        => 'textblock-titled',
                        'section'     => 'header-options',
                ),
/* ------------------------------------ 
 Menu Options 
 ------------------------------------ */
		array(
			'id'		=> 'menu_typography',
			'label'		=> __( 'Menu Typography', 'maddos' ),
			'desc'		=> __( 'Change the default typography for the menu.', 'maddos' ),
			'type'		=> 'typography',
			'section'	=> 'menu-options',
		),
		array(
			'id'		=> 'menu_anchor_colors',
			'label'		=> __( 'Menu Anchor Link Colors', 'maddos' ),
			'desc'		=> __( 'Change the anchor link colors for the menu.', 'maddos' ),
			'type'		=> 'link-color',
			'section'	=> 'menu-options',
		),
/* ------------------------------------ 
 Post Options 
 ------------------------------------ */

                array(
			'id'		=> 'post_layout',
                        'label'		=> __('Single Post Layout', 'maddos'),
                        'desc'		=> __('Maddos layout shows featured image in left half and post content in right half.', 'maddos'),
			'std'		=> 'maddos-scroll',
                        'type'		=> 'radio',
                        'section'	=> 'post-options',
			'choices'	=> array(
				array(
					'value'		=> 'maddos-scroll',
					'label'		=> 'Maddos Format'
				),
				array(
					'value'		=> 'wordpress',
					'label'		=> 'WordPress default'
				),
			)
                ),
		array(
			'id'		=> 'post_header_typography',
			'label'		=> __( 'Post Header Typography', 'maddos' ),
			'desc'		=> __( 'Change the default typography for the post header.', 'maddos' ),
			'type'		=> 'typography',
			'section'	=> 'post-options',
		),
		array(
			'id'		=> 'post_content_typography',
			'label'		=> __( 'Post Content Typography', 'maddos' ),
			'desc'		=> __( 'Change the default typography for the post content.', 'maddos' ),
			'type'		=> 'typography',
			'section'	=> 'post-options',
		),
                array(
			'id'		=> 'postlink_newtab_single',
                        'label'		=> __('Open Site Urls in new tab?', 'maddos'),
                        'desc'		=> __('Opens any site url links in a new tab. This can be overridden individually in the Maddos Post Info metabox on the post page.', 'maddos'),
                        'std'           => 'on',
                        'type'          => 'on-off',
                        'section'	=> 'post-options',
                ),
                array(
			'id'		=> 'postlink_nofollow_single',
                        'label'		=> __('No Follow Site Urls?', 'maddos'),
                        'desc'		=> __('Tells search engines to ignore any site url links. This can be overridden individually in the Maddos Post Info metabox on the post page.', 'maddos'),
                        'std'           => 'off',
                        'type'          => 'on-off',
                        'section'	=> 'post-options',
                ),
		array(
			'id'		=> 'post_related',
			'label'		=> __( 'Display Related Posts', 'maddos' ),
			'desc'		=> __( 'The maximum number of related posts to display in this category for each single post review page.', 'maddos' ),
			'std'		=> 4,
			'type'		=> 'numeric-slider',
			'section'	=> 'related-options',
			'min_max_step'	=> '0,20,1',
		),
                array(
			'id'		=> 'related_flow',
                        'label'		=> __('Related Posts Links', 'maddos'),
                        'desc'		=> __('How to generate the post links on related post title and image. The \'Click here for more...\' will always link to the related post review page, if any.', 'maddos'),
			'std'		=> 'default',
                        'type'		=> 'radio',
                        'section'	=> 'related-options',
			'choices'	=> array(
				array(
					'value'		=> 'default',
					'label'		=> 'Generate links to visit external Site Urls'
				),
				array(
					'value'		=> 'review',
					'label'		=> 'Generate links to single post review pages'
				),
			)
                ),
		array(
			'id'		=> 'post_related_order',
			'label'		=> __( 'Related Posts Order', 'maddos' ),
			'desc'		=> __( 'Specify how to order the related posts.', 'maddos' ),
			'std'		=> 'rand',
			'type'		=> 'select',
			'section'	=> 'related-options',
			'choices'	=> array(
				array(
					'value' => 'none',
					'label' => 'none'
				),
				array(
					'value' => 'ID',
					'label' => 'ID'
				),
				array(
					'value' => 'author',
					'label' => 'author'
				),
				array(
					'value' => 'title',
					'label' => 'title'
				),
				array(
					'value' => 'date',
					'label' => 'date'
				),
				array(
					'value' => 'modified',
					'label' => 'modified'
				),
				array(
					'value' => 'parent',
					'label' => 'parent'
				),
				array(
					'value' => 'rand',
					'label' => 'rand'
				),
				array(
					'value' => 'comment_count',
					'label' => 'comment_count'
				),
				array(
					'value' => 'alexaRank',
					'label' => 'Alexa Rank'
				),
			),
		),
		array(
			'id'		=> 'post_related_direction',
			'label'		=> __( 'Related Posts Order Direction', 'maddos' ),
			'desc'		=> __( 'Specify the direction of the order of the related posts.', 'maddos' ),
			'std'		=> 'DESC',
			'type'		=> 'select',
			'section'	=> 'related-options',
			'choices'	=> array(
				array(
					'value' => 'DESC',
					'label' => 'DESC'
				),
				array(
					'value' => 'ASC',
					'label' => 'ASC'
				),
			),
		),
		array(
			'id'		=> 'related_typography',
			'label'		=> __( 'Related Posts Typography', 'maddos' ),
			'desc'		=> __( 'Change the default typography for the related post content.', 'maddos' ),
			'type'		=> 'typography',
			'section'	=> 'related-options',
			'condition'	=> 'post_related:greater_than(0)'
		),
		array(
			'id'		=> 'post_related_thumbs',
			'label'		=> __( 'Related Posts Thumbnail Style', 'maddos' ),
			'desc'		=> __( 'Specify the thumbnail style of the related posts.', 'maddos' ),
			'std'		=> 'round',
			'type'		=> 'select',
			'section'	=> 'related-options',
			'choices'	=> array(
				array(
					'value' => 'round',
					'label' => 'round'
				),
				array(
					'value' => 'square',
					'label' => 'square'
				),
			),
		),
/* ------------------------------------ 
 Archive Options 
 ------------------------------------ */
                array(
                        'id'		=> 'archive_page_text',
                        'label'		=> __('Archive Options', 'maddos'),
                        'desc'		=> __('An archive page in WordPress is referring to a collection of posts grouped by category, author, date, tag, search term, etc.', 'maddos' ),
                        'type'		=> 'textblock-titled',
                        'section'	=> 'archive-options',
                ),
                array(
			'id'		=> 'archive_taxonomy_desc',
                        'label'		=> __('Archive Taxonomy Description', 'maddos'),
                        'desc'		=> __('How to display the category or tag description on archive pages.', 'maddos'),
			'std'		=> 'default',
                        'type'		=> 'radio',
                        'section'	=> 'archive-options',
			'choices'	=> array(
				array(
					'value'		=> 'default',
					'label'		=> 'Display the full description'
				),
				array(
					'value'		=> 'sentence',
					'label'		=> 'Display the first sentence only'
				),
				array(
					'value'		=> 'none',
					'label'		=> 'Do not display the description'
				),
			)
                ),
                array(
			'id'		=> 'archive_flow',
                        'label'		=> __('Archive Post Links', 'maddos'),
                        'desc'		=> __('How to generate the post links on Archive pages such as category, tag and search pages.', 'maddos'),
			'std'		=> 'site_url',
                        'type'		=> 'radio',
                        'section'	=> 'archive-options',
			'choices'	=> array(
				array(
					'value'		=> 'site_url',
					'label'		=> 'Generate links to visit external Site Urls'
				),
				array(
					'value'		=> 'review',
					'label'		=> 'Generate links to single post review pages'
				),
			)
                ),
                array(
			'id'		=> 'archive_layout',
                        'label'		=> __('Archive Layout', 'maddos'),
                        'desc'		=> __('How to display archive pages.', 'maddos'),
			'std'		=> 'list',
                        'type'		=> 'radio',
                        'section'	=> 'archive-options',
			'choices'	=> array(
				array(
					'value'		=> 'list',
					'label'		=> 'List Format'
				),
				array(
					'value'		=> 'grid',
					'label'		=> 'Grid Format'
				),
			)
                ),
		array(
			'id'		=> 'post_order',
			'label'		=> __( 'Archive Posts Order', 'maddos' ),
			'desc'		=> __( 'Specify how to order the posts on archive pages.', 'maddos' ),
			'std'		=> 'date',
			'type'		=> 'select',
			'section'	=> 'archive-options',
			'choices'	=> array(
				array(
					'value' => 'none',
					'label' => 'none'
				),
				array(
					'value' => 'ID',
					'label' => 'ID'
				),
				array(
					'value' => 'author',
					'label' => 'author'
				),
				array(
					'value' => 'title',
					'label' => 'title'
				),
				array(
					'value' => 'date',
					'label' => 'date'
				),
				array(
					'value' => 'modified',
					'label' => 'modified'
				),
				array(
					'value' => 'parent',
					'label' => 'parent'
				),
				array(
					'value' => 'rand',
					'label' => 'rand'
				),
				array(
					'value' => 'comment_count',
					'label' => 'comment_count'
				),
				array(
					'value' => 'alexaRank',
					'label' => 'Alexa Rank'
				),
			),
		),
		array(
			'id'		=> 'post_order_direction',
			'label'		=> __( 'Archive Posts Order Direction', 'maddos' ),
			'desc'		=> __( 'Specify the direction of the order of the posts on archive pages.', 'maddos' ),
			'std'		=> 'DESC',
			'type'		=> 'select',
			'section'	=> 'archive-options',
			'choices'	=> array(
				array(
					'value' => 'DESC',
					'label' => 'DESC'
				),
				array(
					'value' => 'ASC',
					'label' => 'ASC'
				),
			),
		),
/* ------------------------------------ 
 Footer Options 
 ------------------------------------ */
                array(
                        'id'		=> 'footer_widget_area',
                        'label'		=> __('Footer Widget Area', 'maddos'),
                        'desc'		=> __('To edit the footer area widgets, use the WordPress Appearance-&gt;Widgets menu option. It acts just like a full width sidebar. You can use it to display a text widget, ad widget, carousel widget, etc.', 'maddos'),
                        'type'		=> 'textblock-titled',
                        'section'	=> 'footer-options',
                ),
                array(
                        'id'		=> 'copyright_text',
                        'label'		=> __( 'Copyright Text', 'maddos' ),
                        'desc'		=> __('The text shown in the coypright bar. If not specified, the copyright bar will not be displayed.', 'maddos' ),
			'std'		=> '',
                        'type'		=> 'text',
                        'section'	=> 'footer-options',
                ),
		array(
			'id'		=> 'copyright_background',
			'label'		=> __( 'Copyright Bar Background', 'maddos' ),
			'desc'		=> __( 'Change the background values for the copyright bar.', 'maddos' ),
			'type'		=> 'background',
			'section'	=> 'footer-options',
			'condition'	=> 'copyright_text:not()'
		),
		array(
			'id'		=> 'copyright_typography',
			'label'		=> __( 'Copyright Typography', 'maddos' ),
			'desc'		=> __( 'Change the default typography for the copyright bar.', 'maddos' ),
			'type'		=> 'typography',
			'section'	=> 'footer-options',
			'condition'	=> 'copyright_text:not()'
		),
/* ------------------------------------ 
 Custom CSS Options 
 ------------------------------------ */
                array(
                        'id'            => 'custom_css',
                        'label'         => __( 'Custom CSS Changes', 'maddos' ),
			'desc'		=> __( 'Enter any custom CSS that is not covered in the Theme Options.', 'maddos' ),
                        'std'           => '',
                        'type'          => 'css',
                        'section'       => 'custom-css',
                ),
	)
  );
/* ------------------------------------ 
 License 
 ------------------------------------ */
if ( defined( 'MADDOS_ENVATO' ) && true === MADDOS_ENVATO ) {
$license = array (
                array(
                        'id'		=> 'license_text',
                        'label'		=> __('Maddos License', 'maddos'),
                        'desc'		=> sprintf( __('License the theme and get automatic updates through the WordPress admin.', 'maddos' ) ) . maddos_license_status(),
                        'type'		=> 'textblock-titled',
                        'section'	=> 'license',
                ),
		array(
			'id'            => 'user_id',
			'label'         => __( 'Envato Username', 'maddos' ),
                        'desc'		=> sprintf( __('This is the username used when purchasing the product.', 'maddos' ) ),
			'std'           => '',
			'type'          => 'text',
			'section'       => 'license',
		),
		array(
			'id'            => 'user_code',
			'label'         => __( 'Envato Purchase Code', 'maddos' ),
                        'desc'		=> sprintf( __('The unique purchase code you received when purchasing the product.
', 'maddos' ) ),
			'std'           => '',
			'type'          => 'text',
			'section'       => 'license',
		),
                array(
			'id'		=> 'beta_updates',
                        'label'		=> __('Check for Beta Updates?', 'maddos'),
                        'desc'		=> sprintf( __( 'Beta updates are used to test bugfixes and new features before releasing official versions.', 'maddos'), "https://fontawesome.com/" ),
                        'std'           => 'off',
                        'type'          => 'on-off',
                        'section'	=> 'license',
                ),
  );
}
else {
$license = array (
                array(
                        'id'		=> 'license_text',
                        'label'		=> __('Maddos License', 'maddos'),
                        'desc'		=> sprintf( __('License the theme and get automatic updates through the WordPress admin.', 'maddos' ) ) . maddos_license_status(),
                        'type'		=> 'textblock-titled',
                        'section'	=> 'license',
                ),
		array(
			'id'            => 'user_id',
			'label'         => __( 'Purchase Email', 'maddos' ),
                        'desc'		=> sprintf( __('This is the email used when purchasing the product.', 'maddos' ) ),
			'std'           => '',
			'type'          => 'text',
			'section'       => 'license',
		),
		array(
			'id'            => 'user_code',
			'label'         => __( 'Order ID', 'maddos' ),
                        'desc'		=> sprintf( __('The unique order ID you received when purchasing the product.
', 'maddos' ) ),
			'std'           => '',
			'type'          => 'text',
			'section'       => 'license',
		),
                array(
			'id'		=> 'beta_updates',
                        'label'		=> __('Check for Beta Updates?', 'maddos'),
                        'desc'		=> sprintf( __( 'Beta updates are used to test bugfixes and new features before releasing official versions.', 'maddos'), "https://fontawesome.com/" ),
                        'std'           => 'off',
                        'type'          => 'on-off',
                        'section'	=> 'license',
                ),
  );
}
  $custom_settings['settings'] = array_merge( $custom_settings['settings'], $license );
  
  /* allow settings to be filtered before saving */
  $custom_settings = apply_filters( ot_settings_id() . '_args', $custom_settings );
  
  /* settings are not the same update the DB */
  if ( $saved_settings !== $custom_settings ) {
    update_option( ot_settings_id(), $custom_settings ); 
  }
  
  /* Lets OptionTree know the UI Builder is being overridden */
  global $ot_has_custom_theme_options;
  $ot_has_custom_theme_options = true;
  
}

