<?php

/**
 * Register TGM plugins
 */
require_once get_theme_file_path( '/admin/TGM-Plugin-Activation-2.6.1/class-tgm-plugin-activation.php' );
add_action( 'tgmpa_register', 'maddos_register_required_plugins' );
if ( ! function_exists( 'maddos_register_required_plugins' ) ) :
function maddos_register_required_plugins() {
	$plugins = array(
		array(
			'name'			=> 'Advanced Custom Fields',
			'slug'			=> 'advanced-custom-fields',
			'required'		=> true,
		),
		array(
			'name'			=> 'Maddos Theme Extensions',
			'slug'			=> 'maddos-theme-extensions',
			'required'		=> true,
			'source'		=> 'https://www.superblogme.com/wp-update-server/packages/maddos-theme-extensions.zip',
			'version'		=> '0.1'
		),
		array(
			'name'			=> 'WP-PostRatings',
			'slug'			=> 'wp-postratings',
			'required'		=> false,
		),
		array(
			'name'			=> 'WP-PostViews',
			'slug'			=> 'wp-postviews',
			'required'		=> false,
		),
		array(
			'name'			=> 'Menu Icons',
			'slug'			=> 'menu-icons',
			'required'		=> false,
		),
		array(
			'name'			=> 'WP Posts Carousel',
			'slug'			=> 'wp-posts-carousel',
			'required'		=> false,
		),
		array(
			'name'			=> 'Taxonomy Terms Order',
			'slug'			=> 'taxonomy-terms-order',
			'required'		=> false,
		),
		array(
			'name'			=> 'User Submitted Posts',
			'slug'			=> 'user-submitted-posts',
			'required'		=> false,
		),
		array(
			'name'			=> 'Widget Context',
			'slug'			=> 'widget-context',
			'required'		=> false,
		),
		array(
			'name'			=> 'Clasic Widgets',
			'slug'			=> 'classic-widgets',
			'required'		=> false,
		),
		array(
			'name'			=> 'Classic Editor',
			'slug'			=> 'classic-editor',
			'required'		=> false,
		),
	);

	$config = array(
		'id'           => 'maddos',                // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'parent_slug'  => 'themes.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}
endif;

function maddos_dismissable_notice_for_recommended_plugins() {
	global $current_user; 

	if( $current_user ) {
		$activation_notice_dismissed = get_user_meta( $current_user->ID, 'tgmpa_dismissed_notice_maddos', true );

		if ( ! is_plugin_active('maddos-theme-extensions/maddos-theme-extensions.php') && $activation_notice_dismissed == true ) {
			update_user_meta( $current_user->ID, 'tgmpa_dismissed_notice_maddos', false, true );
		}
	}
}
add_action('admin_notices', 'maddos_dismissable_notice_for_recommended_plugins');

?>
