<?php

/*
 * Initialize the Theme Update Checker
 */
add_action( 'after_setup_theme', 'maddos_tuc_setup' );
function maddos_tuc_setup() {

	$name = str_replace( '-beta', '', ot_get_option( 'user_id' ), $beta );
	if ( empty( $beta ) ) $beta = ot_get_option( 'beta_updates', '' );
	else $beta = 'on';
	$key = 'maddos-' . $name;
	$key = substr( $key, 0, 45 );
	$transient = get_transient( $key );

	$code = ot_get_option( 'user_code' );
	$debug = apply_filters( 'maddos_debug', false );

	if ( ! $name || ! $code ) return;

	if ( false === $transient && defined( 'MADDOS_ENVATO' ) && true === MADDOS_ENVATO ) {
		$msg  = EnvatoApiMaddos::verifyPurchase( $code, $name );
		if ( ! empty( $msg ) ) {
			maddos_add_admin_notice( "<div class='error'><p>" . $msg . "</p></div>" );
			return;
		}
	}
	else if ( false === $transient ) {
		$request = 'https://www.superblogme.com/verify.php?license=' . $code . '&username=' . $name . '&site=' . site_url();
		$response = wp_remote_get( $request );
		set_transient( $key, 'PlaceHolder', 30 ); // don't check more than once per 30s
		if ( is_wp_error( $response ) ) {
			$msg = sprintf( __( "%s WP Error: %s", 'maddos' ), __FUNCTION__, $response->get_error_message() );
			maddos_add_admin_notice( "<div class='error'><p>" . $msg . "</p></div>" );
			return;
		}
		else if ( strpos( $response['body'], maddos_decode( 'U1VDQ0VTUw==' ) ) !== false ) {
			set_transient( $key, $response['body'], MONTH_IN_SECONDS );
		}
		else {
			maddos_add_admin_notice( "<div class='error'><p>" . $response['body'] . "</p></div>" );
			return;
		}
	}
	else if ( 'PlaceHolder' === $transient ) {
		return;
	}

	// set up the TUC
	$url = $beta && $beta === 'on' ? 'https://www.superblogme.com/test-update-server/maddos.json' : $url = 'https://www.superblogme.com/wp-update-server/maddos.json';

	require_once plugin_dir_path( __FILE__ ) . 'theme-updates/theme-update-checker.php';
	$maddos_UpdateChecker = new ThemeUpdateChecker(
		'maddos',
		$url
	);
	$maddos_UpdateChecker->addResultFilter( 'maddos_TUC_callback' );

}

/*
 * Add our own arguments onto the TUC
 */
function maddos_TUC_callback( $TUC, $get )
{
	if ( $TUC ) {
		$TUC->download_url .= "&license=" . ot_get_option( 'user_id' );
		$TUC->download_url .= "&code=" . ot_get_option( 'user_code' );
		return $TUC;
	}
	return null;
}

////////////////////////////////////////////////////////////////////////////////////////////

if ( !class_exists( 'EnvatoApiMaddos' ) ) {
	
	class EnvatoApiMaddos {
		
		// Bearer, no need for OAUTH token, change this to your bearer string
		// https://build.envato.com/my-apps/#tokens
		private static $bearer = "xaWVKX1aqpxxpk1UdOIC2Z8b0TUe77dw";
		
		static function getPurchaseData( $code ) {
			
			//setting the header for the rest of the api
			$bearer = 'Bearer ' . self::$bearer;
			$header = array(
				 'Authorization' => $bearer 
			);
			
			$verify_url = 'https://api.envato.com/v2/market/author/sale?code=' . $code;
			
			$response = wp_remote_get( $verify_url, array(
				 'headers' => $header,
				'user-agent' => 'Maddos' 
			) );
			
			return $response;
		}
		
		static function verifyPurchase( $code, $username ) {

			$response = self::getPurchaseData( $code );
			
			if ( is_wp_error( $response ) ) {
				return sprintf( __( 'WP error %s in %s - %s ', 'maddos' ), $response->get_error_code(), __FUNCTION__, $response->get_error_message() );
			}
			
			$verify_obj = json_decode( wp_remote_retrieve_body( $response ) );

			$verify_obj = apply_filters( 'maddos_verify', $verify_obj );

			$msg = null;
			
			// Check for correct verify code
			if ( ( false === $verify_obj ) || !is_object( $verify_obj ) )
				$msg = __( "Could not connect to Envato API server.", 'maddos' );
			else if ( isset( $verify_obj->error ) && isset( $verify_obj->description ) )
				$msg = $verify_obj->description;
			else if ( !isset( $verify_obj->item ) || !isset( $verify_obj->item->name ) )
				$msg = __( "Envato API did not return item information.", 'maddos' );
			
			// Check for proper item name
/* JPH add Envato support?
			else if ( false === stripos( $verify_obj->item->name, 'Maddos' ) )
				$msg = sprintf( __( "Envato API states the purchase code is for %s.", 'maddos' ), $verify_obj->item->name );
			
			// Check for proper item id
			else if ( $verify_obj->item->id != XXXX )
				$msg = __( "Envato API states the purchase code is for another product id.", 'maddos' );
			
			// Check for username match
			else if ( !empty( $verify_obj->buyer ) && strcmp( $verify_obj->buyer, $username ) )
				$msg = __( "Envato states the purchase code is for another username.", 'maddos' );
*/
			
			else if ( isset( $verify_obj->supported_until ) && ! empty( $verify_obj->supported_until ) ) {
			
				$key = 'maddos-' . $username;
				$key = substr( $key, 0, 45 );
				set_transient( $key, "SUCCESS. Premium support expires " . $verify_obj->supported_until, MONTH_IN_SECONDS );
			} else
				$msg = __( "Strange. Envato API did not return a support field.", 'maddos' );
			return $msg;
		}
		
	}
} // end EnvatoAPI

?>
