<?php
/**
 * The default template for displaying archive grid content
 * Used for index/categories/search, etc.
 */

$grid = ot_get_option( 'grid_option', 'col-sm-' ); 
$col = 1;

// set up our custom query:
$orderby = apply_filters( 'maddos_archive_orderby', ot_get_option( 'post_order', 'date' ) );
$order = apply_filters( 'maddos_archive_order', ot_get_option( 'post_order_direction', 'DESC' ) );

$args = array( 'orderby' => $orderby, 'order' => $order );

if ( $orderby === 'alexaRank' ) {
	$args['orderby']	= 'meta_value_num';
	$args['meta_key'] 	= 'alexaRank';
}

$paged = get_query_var( 'paged', 1 );
if ( $paged ) {
	$args['paged'] = $paged;
}

$search = get_search_query();
if ( ! empty( $search ) ) {
	$args['s'] = $search;
}

if ( is_category() ) {
	$cat = get_category( get_query_var( 'cat' ) );
	if ( isset( $cat->term_id ) ) {
		$args['cat'] = $cat->term_id;
	}
}
else if ( is_tag() ) {
	$tag = get_query_var( 'tag_id' );
	if ( ! empty( $tag ) ) {
		$args['tag_id'] = $tag;
	}
}


$args = apply_filters( 'maddos_archive_posts', $args );

$wp_query = new WP_Query( $args );

if ( have_posts() ) :
?>

<div class="container">
<div class="maddos-archive-grid">

<?php while ( have_posts() ) : the_post(); $col++; ?>

	<?php if ( $col % 4 === 1 ) : ?>
	<div class="row">
	<?php endif; ?>

	<?php 
		get_template_part( 'post-content', 'grid' );
	?>

	<?php if ( $col % 4 === 1 ) : ?>
	</div>
	<?php endif; ?>
<?php endwhile; ?>

</div>
</div>

<?php 
else:
?>
<div class="container">
	<div class="row">
		<div class="<?php echo sanitize_html_class( $grid );?>12">
			<p><?php _e( '<h4>No results were found.</h4>', 'maddos' ); ?></p>
		</div>
	</div>
</div>
<?php
endif;
?>
