<div class="container maddos-directory-container">
    <div class="row maddos-directory">

<?php 
	$max_columns = 4;

	$grid = ot_get_option( 'grid_option', 'col-sm-' ); 

	// Count how many Directory columns are being used to set up Bootstrap grid
	$num_columns = 0;
	for ( $column = 1; $column <= $max_columns; $column++ ) {
		$sidebar = 'maddos-column' . $column . '-area';
		if ( is_active_sidebar( $sidebar ) ) {
			$num_columns++;
		}
	}

	// DEPRECATED --------------------------------------------------------------------------------
	// if $num_columns still 0, they may still be using DEPRECATED way in Maddos Settings...
	$old_method = $show_defaults = false;
	// $num_columns = 0; #JPH to force old method for backward testing
	if ( ! $num_columns 
			&& empty( ot_get_option( 'content_column1' ) ) 
			&& empty( get_post_meta( get_the_ID(), 'content_columns', true ) )
	) {
		$show_defaults = true;
	}
	else if ( ! $num_columns ) {
		$old_method = true;
		$mobile_columns = ot_get_option( 'mobile_columns', 'off' );
		if ( wp_is_mobile() && $mobile_columns === 'on' ) {
			$num_columns = 1;
			$which_column = 'mobile_column';
		}
		else {
			// see if a page overrides default Directory Options
			$page_columns = get_post_meta( get_the_ID(), 'content_columns', true );

			$max_columns = empty( $page_columns ) ? ot_get_option( 'content_columns' ) : $page_columns;
			$num_columns = $max_columns;

			$which_column = 'content_column';
		}
		if ( ! $num_columns ) $num_columns = 4;
	}

	if ( true === $old_method ) {
	$def_max_height = ot_get_option( 'category_default_max_height' );
	$orderby = ot_get_option( 'post_order', 'date' ); 
	$order = ot_get_option( 'post_order_direction', 'DESC' ); 
	$show_hover = ot_get_option( 'postlink_hover', 'off' );
	$flow = ot_get_option( 'directory_flow', 'default' );
	$nofollow = ot_get_option( 'postlink_nofollow', 'off' );
	$open_close = ot_get_option( 'show_open_close', 'off' );
	if ( is_array( $show_hover ) && $show_hover[0] === 'yes' ) $show_hover = 'on'; // backwards compat < v1.3
	$template_uri = get_template_directory_uri();
	$cat_action = ot_get_option( 'category_link_action', 'nothing' );
	$pdo = ot_get_option( 'post_display_override', null );
	$postlink_new = apply_filters( 'maddos_postlink_new', ot_get_option( 'postlink_new', '3' ) );
	}
	// --------------------------------------------------------------------------------

	$boot_columns = $num_columns ? $num_columns : 4;
	$boot = $grid . ( 12 / $boot_columns );

	for ( $column = 1; $column <= $max_columns; $column++ ) {

	// DEPRECATED --------------------------------------------------------------------------------
		if ( true === $old_method ) {
?>
		<div class="maddos-column column<?php echo sanitize_html_class( $column );?> <?php echo sanitize_html_class( $boot );?>">
<?php 
		// see if a page overrides default Directory Options
		$page_categories = get_post_meta( get_the_ID(), 'content_column' . $column, true );

		$categories = empty( $page_categories ) || empty( $page_columns ) ? ot_get_option( $which_column . $column ) : $page_categories;
		$categories = apply_filters( 'maddos_content_column', $categories, $column );

		if ( is_array( $categories ) )
		foreach ( $categories as $category_id ) {

			$term = get_category( $category_id );

			if ( ! $term ) continue;
?>
			<div class="maddos-category-container">


				<div class="maddos-category-header" id="<?php echo esc_html( $term->slug );?>">
				<?php $cat_icon = function_exists( 'get_field' ) ? get_field('cat_icon', 'category_'.$term->term_id) : null; 
				if ( filter_var( $cat_icon, FILTER_VALIDATE_URL ) ) : ?>
					<span class="maddos-category-icon"><img alt="<?php echo esc_html( $term->name );?>" title="<?php echo esc_html( $term->name ); ?>" src="<?php echo wp_kses_post( $cat_icon ); ?>" /></span>
				<?php elseif ( $cat_icon ) : ?>
					<span class='maddos-category-icon'><?php echo wp_kses_post( $cat_icon );?></span>
				<?php endif; ?>
				<?php if ( $cat_action === 'category-page' ) $cat_link = apply_filters( 'maddos_category_link', get_term_link( $term ), $category_id );?>
				<?php if ( $cat_action === 'category-page' && $cat_link ) : ?>
					<h3 class="maddos-category-header-title"><a href="<?php echo esc_url( $cat_link );?>"><?php echo esc_html( $term->name );?></a></h3>
				<?php else : ?>
					<h3 class="maddos-category-header-title"><?php echo esc_html( $term->name );?></h3>
				<?php endif; ?>
				<?php if ( $open_close === 'on' ) : ?>
				<div class="maddos-open-close-button open"></div>
				<?php endif; ?>
				</div>

				<?php 
					$cat_height = function_exists( 'get_field' ) ? get_field('cat_height', 'category_'.$term->term_id) : null;
					$height = $cat_height ? $cat_height : $def_max_height;
				?>
				<?php $style = $height ?  'style="max-height:'.$height.'px;"' : ''; ?>
				<div class="maddos-category-wrapper" <?php echo htmlspecialchars( $style, ENT_NOQUOTES );?> id="<?php echo esc_html( $term->slug );?>-list">
				<?php
				$description = category_description( $category_id );
				$description = maddos_taxonomy_description( $description, $category_id );
				if ( ! empty ( $description ) ) {
					echo '<div class="maddos-taxonomy-description">' . $description . '</div>';
				}
				?>

				<ol>
<?php
				if ( $orderby === 'none' ) {	// order must be set to 'none' for Intuitive Custom Posts Order to work
					$args = array( 'posts_per_page' => -1, 'cat' => $term->term_id );
				}
				else {
					$args = array( 'posts_per_page' => -1, 'cat' => $term->term_id, 'orderby' => $orderby, 'order' => $order );
				}
				if ( $orderby === 'alexaRank' ) {
					$args['orderby'] = 'meta_value_num';
					$args['meta_key'] = 'alexaRank';
				}

				$args = apply_filters( 'maddos_directory_posts', $args, $column );

				$the_query = new WP_Query( $args ); 

				// special case: if order by alexaRank and some posts have no alexa data, put those last.
				if ( isset( $args['meta_key'] ) && $args['meta_key'] === 'alexaRank' ) {
					unset( $args['meta_key'] );
					$args['orderby'] = 'date';
					$args['order'] = 'DESC';
					$args['meta_query'] = array(
						array(
							'key'	=> 'alexaRank',
							'compare' => 'NOT EXISTS'
						)
					);
					$args = apply_filters( 'maddos_directory_posts_no_alexa', $args, $column );
					$alexa_query = new WP_Query( $args );

					// now append the posts without any alexa data
					$special_query = new WP_Query();
					$special_query->posts = array_merge( $the_query->posts, $alexa_query->posts );
					$special_query->post_count = $the_query->post_count + $alexa_query->post_count;
					$the_query = $special_query;
				}

				if ( $the_query->have_posts() ) { while ( $the_query->have_posts() ) { ?>
				
				<li>
					<?php 
					$the_query->the_post();
					$title = get_the_title();
					$postID = get_the_ID();
					$icon = function_exists( 'get_field' ) ? get_field( 'site_icon', $postID ) : null ;
					$icon = apply_filters( 'maddos_get_icon', $icon );
					// in case site switched to ssl but still using http links:
					if ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') || 
    $_SERVER['SERVER_PORT'] == 443) {
						$icon = str_replace( 'http:', 'https:', $icon );
					}
					$site_icon = $icon && filter_var( $icon, FILTER_VALIDATE_URL ) ? "<span class='maddos-icon site-icon'><img width='16' height='16' alt='{$title}' title='{$title}' src='{$icon}' /></span>" : "<span class='maddos-icon site-icon'>{$icon}</span>"; 

					$site_url = function_exists( 'get_field' ) ? get_field( 'site_url', $postID ) : null;
					$site_url = apply_filters( 'maddos_get_site_url', $site_url );
					$href = $site_url && $flow === 'default' ? $site_url : get_permalink();
					$href = apply_filters( 'maddos_directory_post_href', $href, $site_url, $post->ID );
					$hover = $show_hover === 'on' && has_post_thumbnail( $postID ) ? get_the_post_thumbnail( $postID, 'hover-thumb', array('class'=>'img-responsive maddos-image-hover') ) : '';
					$target = $site_url === $href ? 'target="_blank"' : '';
					$target = apply_filters( 'maddos_directory_post_target', $target, $href, $postID );
					$rel = ( $site_url === $href ) ? $nofollow === 'on' ? 'rel="nofollow noopener"' : 'rel="noopener"' : '';
					$rel = apply_filters( 'maddos_directory_post_rel', $rel, $href, $postID );
					$mobile = function_exists( 'get_field' ) && get_field( 'mobile_friendly', $postID ) ? ' <span class="maddos-mobile-friendly-icon"></span>' : '';
					$age = ( time() - strtotime( $post->post_date ) ) / 86400;
					$new_icon = $age <= $postlink_new ? ' <span class="maddos-new-icon"></span>' : '';

					$sticky_icon = is_sticky( $postID ) ? ' <span class="maddos-sticky-icon"></span>' : '';
					$add_icon = function_exists( 'get_field' ) ? get_field( 'additional_icon', $postID ) : null;
					$add_icon = apply_filters( 'maddos_get_additional_icon', $add_icon );
					$additional_icon = $add_icon ? filter_var( $add_icon, FILTER_VALIDATE_URL ) ? " <span class='maddos-icon additional-icon'><img width='16' height='16' alt='{$title}' title='{$title}' src='{$add_icon}' /></span>" : " <span class='maddos-icon additional-icon'>{$add_icon}</span>" : ''; 

					$review_link = apply_filters( 'maddos_get_review_link', get_permalink() );
					$review = ( isset( $pdo[0] ) && $pdo[0] === "yes" ) || apply_filters( 'the_content', get_the_content() ) ? "<div class='maddos-review'><a href='" . $review_link . "'><span class='maddos-site-review-icon'></span></a></div>" : '';

					$extra = apply_filters( 'maddos_category_post_extra', '' );

					printf( '%s <a class="maddos-link" title="%s" %s %s href="%s">%s %s %s %s %s %s %s</a> %s', $site_icon, $title, $target, $rel, $href, $title, $sticky_icon, $additional_icon, $mobile, $new_icon, $extra, $hover, $review );
					?>
				</li>
<?php 				} }
				wp_reset_postdata();
?>
				</ol>
				<div class="clearfix"></div>
				</div>
			</div>
<?php 	
		} 
?>
		</div>
<?php
			continue;
		}
	// --------------------------------------------------------------------------------

		$sidebar = 'maddos-column' . $column . '-area';
		if ( ! is_active_sidebar( $sidebar ) && false === $show_defaults ) {
			continue;
		}

		?>
		<div class="maddos-column column<?php echo sanitize_html_class( $column );?> <?php echo sanitize_html_class( $boot );?>">
		<?php
			if ( ! dynamic_sidebar( $sidebar ) ) {
		?>
			<aside class="widget maddos-widget">
				<h3 class="maddos-widget-title"><?php printf( "Column %d", $column );?></h3>
				<ul>
					<li><a href="<?php echo admin_url( 'widgets.php' );?>">Add Widgets</a></li>
				</ul>
			</aside>
		<?php
			}
		?>
		</div>
		<?php
	}
?>
    </div>
    <div class="row maddos-legend">
		<div class="<?php echo sanitize_html_class( $grid );?>8"></div>
		<div class="<?php echo sanitize_html_class( $grid );?>2" id="maddos-legend-mobile-friendly-icon"><span class="maddos-mobile-friendly-icon"></span> <?php _e( 'Mobile Friendly Site.', 'maddos' ); ?></div>
		<div class="<?php echo sanitize_html_class( $grid );?>2" id="maddos-legend-site-review-icon"><span class="maddos-site-review-icon"></span> <?php _e( 'Site Review Available.', 'maddos' ); ?></div>
    </div>
</div>
