<?php 

$post_related = ot_get_option('post_related');
$post_related = apply_filters('maddos_show_post_related', $post_related);

if ( $post_related ) { 
// set up our custom query:
$post_related_order = ot_get_option('post_related_order', 'rand');
$post_related_direction = ot_get_option('post_related_direction', 'desc');
$post_related_thumbs = ot_get_option('post_related_thumbs', 'round');

$args = array( 'posts_per_page' => $post_related, 'post__not_in' => array( get_the_ID() ), 'orderby' => $post_related_order, 'order' => $post_related_direction);

if ( $post_related_order === 'alexaRank' ) {
	$args['orderby'] = 'meta_value_num';
	$args['meta_key'] = 'alexaRank';
}

if ( $post_related_thumbs === 'round' ) {
	$related_class = 'img-circle img-responsive';
}
else {
	$related_class = 'img-responsive';
}

$categories = get_the_category();
$catIDs = array();
foreach ( $categories as $category ) {
	if ( isset( $category->term_id ) ) $catIDs[] = $category->term_id;
}
if ( ! empty( $catIDs ) ) {
	$args['cat'] = implode( ',', $catIDs );
}

$args = apply_filters( 'maddos_related_posts', $args );

$the_query = new WP_Query( $args );

$grid = ot_get_option( 'grid_option', 'col-sm-' );
$numrel=0;

if ( $the_query->have_posts() ) {
?>

<div class="container">
	<div class="row">
		<div class="<?php echo sanitize_html_class( $grid );?>12">
			<div class="maddos-link-container">

				<div class="row">
				<div class="<?php echo sanitize_html_class( $grid );?>12">
				<div class="maddos-link-header nocenter maddos-related-sites">
					<h4 class="maddos-post-header">More like <?php the_title();?>:</h4>
					<div class="maddos-link-header-back">
						<a href="#top">
							<?php _e( 'Back To Top', 'maddos' ); ?>
							<span class="glyphicon glyphicon-arrow-up" aria-hidden="true"></span>
						</a>
					</div>
				</div>
				</div>
				</div>

				<div class="row">
				<div class="<?php echo sanitize_html_class( $grid );?>12">
				<div class="maddos-link-content">
					<div class="maddos-url-links-wrapper clearfix">
					<?php $flow = ot_get_option( 'related_flow', 'default' ); ?>
					<?php $newtab = ot_get_option( 'postlink_newtab_single', 'on' ); ?>
					<?php $nofollow = ot_get_option( 'postlink_nofollow_single', 'off' ); ?>
					<?php while ( $the_query->have_posts() ) : 
						$the_query->the_post(); 
						$postID = get_the_ID();
					?>
						<?php if ( $numrel % 4 === 0 ) : ?>
							<div class="row">
						<?php endif; ?>
							<div class="maddos-url-link-container col-md-3">
								<?php
									$site_url = function_exists( 'get_field' ) ? get_field( 'site_url', $postID ) : null;
									$href = $site_url && $flow === 'default' ? $site_url : get_permalink();
									$href = apply_filters( 'maddos_related_post_href', $href, $site_url, $postID );
									$metabox_options = function_exists( 'get_field' ) ? get_field('options' ) : array();
									$target = $newtab === 'on' ? maddos_get_target( true ) : maddos_get_target( false );
									$rel = $nofollow === 'on' ? maddos_get_rel( true, $target ) : maddos_get_rel( false, $target );

									$tn = get_the_post_thumbnail( null, 'related-thumb', array('class'=>$related_class));
									printf( '<a class="maddos-related-link" href="%s" %s %s><h4 class="maddos-no-margins">%s</h4></a>', $href, $target, $rel, get_the_title() );
								?>
								<div class="maddos-url-link-image">
									<?php printf( '<a href="%s" %s %s>%s</a>', $href, $target, $rel, $tn ); ?>
								</div>
								<?php if ( apply_filters( 'the_content', get_the_content() ) ) : ?>
									<a class="related link" href="<?php the_permalink(); ?>"><?php _e( 'Click here for more...', 'maddos' ); ?></a>
								<?php else : ?>
									&nbsp;
								<?php endif; ?>
							</div>
						<?php $numrel++; ?>
						<?php if ( $numrel % 4 === 0 ) : ?>
							</div>
						<?php endif; ?>
					<?php endwhile; ?>
						<?php if ( $numrel % 4 != 0 ) : ?>
							</div>
						<?php endif; ?>
					</div>
				</div>
				</div>
				</div>

			</div>
		</div>
	</div>
</div>

<?php } } ?>
